/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block.growable;

import enemeez.simplefarming.world.gen.feature.tree.FruitTreeFeature;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class SimpleSaplingBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final int type;

    public SimpleSaplingBlock(AbstractBlock.Properties properties, int type) {
        super(properties);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && random.nextInt(7) == 0) {
            this.spawnTree(worldIn, pos, state, random);
        }
    }

    public void spawnTree(ServerWorld worldIn, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((Property)STAGE) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)worldIn, (Random)rand, (BlockPos)pos)) {
                return;
            }
            BlockState leaves = FruitTreeFeature.LOOKUP[this.type - 1];
            FruitTreeFeature.generateTree((IWorld)worldIn, pos, rand, leaves);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAGE});
    }

    public boolean func_176473_a(IBlockReader p_176473_1_, BlockPos p_176473_2_, BlockState p_176473_3_, boolean p_176473_4_) {
        return true;
    }

    public boolean func_180670_a(World p_180670_1_, Random p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return (double)p_180670_1_.field_73012_v.nextFloat() < 0.45;
    }

    public void func_225535_a_(ServerWorld p_225535_1_, Random p_225535_2_, BlockPos p_225535_3_, BlockState p_225535_4_) {
        this.spawnTree(p_225535_1_, p_225535_3_, p_225535_4_, p_225535_2_);
    }
}

